<?php require_once 'config.php'; ?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SMM EISORY</title>
    <link rel="icon" href="icon.png" type="image/png">
    <!-- Google Fonts - Cairo -->
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700;900&display=swap" rel="stylesheet">
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css" rel="stylesheet">
    <!-- Custom CSS -->
    <link href="assets/css/style.css" rel="stylesheet">
    <style>
    body {
        padding-right: 240px !important;
    }
    .sidebar {
        position: fixed;
        top: 0;
        right: 0;
        width: 220px;
        height: 100vh;
        background: #23263a;
        color: #fff;
        z-index: 1040;
        display: flex;
        flex-direction: column;
        box-shadow: -2px 0 16px rgba(0,0,0,0.08);
        transition: right 0.3s ease;
    }
    .hamburger-menu {
        display: none;
        position: fixed;
        top: 18px;
        right: 18px;
        z-index: 2100;
        background: none;
        border: none;
        color: #fff;
        font-size: 1.7rem;
        cursor: pointer;
    }
    .hamburger-menu:focus {
        outline: none;
    }
    .sidebar .sidebar-header {
        padding: 32px 0 24px 0;
        text-align: center;
        border-bottom: 1px solid #31344d;
    }
    .sidebar .sidebar-header .brand {
        font-size: 1.5rem;
        font-weight: 900;
        background: linear-gradient(90deg, #e14eca 0%, #7367f0 100%);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
        display: block;
    }
    .sidebar .sidebar-header .brand-sub {
        color: #fff;
        font-size: 0.9rem;
        font-weight: 400;
        background: none;
        -webkit-text-fill-color: unset;
    }
    .sidebar .nav {
        flex-direction: column;
        margin-top: 32px;
        gap: 6px;
    }
    .sidebar .nav-link {
        color: #fff;
        font-weight: 600;
        font-size: 1.05rem;
        border-radius: 8px;
        padding: 12px 18px;
        margin: 2px 12px;
        transition: background 0.2s, color 0.2s;
        display: flex;
        align-items: center;
        gap: 10px;
    }
    .sidebar .nav-link.active, .sidebar .nav-link:hover {
        background: linear-gradient(90deg, #e14eca 0%, #7367f0 100%);
        color: #fff;
    }
    .sidebar .nav-link.btn {
        font-weight: 700;
        background: linear-gradient(90deg, #e14eca 0%, #7367f0 100%);
        color: #fff;
        margin-top: 18px;
        text-align: center;
        justify-content: center;
    }
    @media (max-width: 991px) {
        body {
            padding-right: 0 !important;
        }
        .hamburger-menu {
            display: block !important;
        }
        .sidebar {
            width: 100vw !important;
            height: 100vh !important;
            right: -100vw !important;
            top: 0;
            background: #23263a;
            z-index: 2000;
            transition: right 0.3s;
        }
        .sidebar.active {
            right: 0 !important;
        }
        .sidebar-header {
            position: relative;
            padding-top: 40px;
        }
        .sidebar .nav {
            flex-direction: column;
            margin: 10px 0;
            padding: 0 10px;
            gap: 2px;
        }
        .sidebar .nav-link {
            font-size: 1rem;
            padding: 10px 10px;
            margin: 0;
            border-radius: 8px;
            text-align: right;
        }
        .sidebar .nav-link.btn {
            margin: 10px 0 0 0;
            padding: 12px 15px;
        }
        .container, .container.mt-4 {
            margin-top: 60px !important;
        }
    }
    @media (max-width: 576px) {
        .sidebar .nav {
            gap: 3px;
        }
        .sidebar .nav-link {
            font-size: 0.85rem;
            padding: 6px 10px;
        }
        .sidebar .nav-link i {
            font-size: 0.9rem;
        }
    }
    .mobile-dropdown {
        display: flex;
        opacity: 0;
        pointer-events: none;
        transform: translateY(-15px) scale(0.98);
        transition: opacity 0.25s, transform 0.25s;
        position: absolute;
        top: 60px;
        right: 16px;
        min-width: 180px;
        background: #23263a;
        border-radius: 8px;
        box-shadow: 0 2px 16px rgba(0,0,0,0.15);
        padding: 8px 0;
        z-index: 2200;
        flex-direction: column;
        align-items: flex-start;
    }
    .mobile-dropdown.show {
        opacity: 1;
        pointer-events: auto;
        transform: translateY(0) scale(1);
    }
    .mobile-dropdown .dropdown-link {
        display: block;
        color: #fff;
        padding: 10px 18px;
        text-decoration: none;
        font-size: 1.05rem;
        border: none;
        background: none;
        width: 100%;
        text-align: right;
        transition: background 0.2s;
    }
    .mobile-dropdown .dropdown-link:hover, .mobile-dropdown .dropdown-link.logout {
        background: linear-gradient(90deg, #e14eca 0%, #7367f0 100%);
        color: #fff;
    }
    .mobile-dropdown .dropdown-link.disabled {
        color: #aaa;
        cursor: default;
        pointer-events: none;
    }
    .mobile-dropdown .dropdown-link.register {
        background: linear-gradient(90deg, #e14eca 0%, #7367f0 100%);
        color: #fff;
        margin: 8px 0 0 0;
        border-radius: 6px;
        text-align: center;
    }
    @media (max-width: 991px) {
        .hamburger-menu {
            display: block !important;
        }
        .mobile-dropdown {
            display: flex;
        }
        .sidebar {
            display: none !important;
        }
    }
    @media (min-width: 992px) {
        .hamburger-menu, .mobile-dropdown {
            display: none !important;
        }
        .sidebar {
            display: flex !important;
        }
    }
    .mouse-trail-dot {
        position: fixed;
        pointer-events: none;
        border-radius: 50%;
        width: 16px;
        height: 16px;
        background: #7c3aed;
        opacity: 0.13;
        z-index: 9980;
        transition: opacity 0.5s, transform 0.5s;
        will-change: transform, opacity;
    }
    .mouse-tail-dot {
        position: fixed;
        pointer-events: none;
        border-radius: 50%;
        width: 12px;
        height: 12px;
        background: #00eaff;
        opacity: 0.18;
        z-index: 9999;
        transition: opacity 0.4s;
        will-change: transform, opacity;
    }
    .mouse-follow-outer {
        position: fixed;
        pointer-events: none;
        border-radius: 50%;
        width: 44px;
        height: 44px;
        background: rgba(130, 80, 220, 0.10);
        border: 2.5px solid #7c3aed;
        z-index: 9999;
        transition: left 0.11s linear, top 0.11s linear;
        will-change: left, top;
        box-sizing: border-box;
    }
    .mouse-follow-inner {
        position: fixed;
        pointer-events: none;
        border-radius: 50%;
        width: 16px;
        height: 16px;
        background: #7c3aed;
        z-index: 10000;
        transition: left 0.09s linear, top 0.09s linear;
        will-change: left, top;
    }
    </style>
</head>
<body>
    <!-- زر الهمبرجر -->
    <button class="hamburger-menu" id="hamburgerMenu">
        <i class="bi bi-list"></i>
    </button>
    <!-- القائمة المنسدلة للموبايل -->
    <div class="mobile-dropdown" id="mobileDropdown">
        <a class="dropdown-link" href="index.php">الرئيسية</a>
        <a class="dropdown-link" href="services.php">الخدمات</a>
        <a class="dropdown-link" href="order-service.php">طلب جديد</a>
        <a class="dropdown-link" href="AddBalance.php">اضافة رصيد</a>
        <a class="dropdown-link" href="payment-methods.php">طرق الدفع</a>
        <a class="dropdown-link" href="contact.php">اتصل بنا</a>
        <?php if (isLoggedIn()): ?>
            <a class="dropdown-link" href="dashboard.php">لوحة التحكم</a>
            <span class="dropdown-link disabled">مرحباً، <?= htmlspecialchars($_SESSION['username'] ?? '') ?></span>
            <a class="dropdown-link logout" href="logout.php"><i class="bi bi-box-arrow-right"></i> تسجيل الخروج</a>
        <?php else: ?>
            <a class="dropdown-link" href="login.php">تسجيل الدخول</a>
            <a class="dropdown-link register" href="register.php"><i class="bi bi-person-plus"></i> إنشاء حساب</a>
        <?php endif; ?>
    </div>
    <!-- القائمة الجانبية للديسكتوب -->
    <aside class="sidebar d-none d-lg-flex" id="sidebar">
        <div class="sidebar-header">
            <span class="brand">SMM ELSORY</span>
        </div>
        <nav class="nav flex-column mt-3">
            <a class="nav-link" href="index.php"><i class="bi bi-house-door"></i> الرئيسية</a>
            <a class="nav-link" href="services.php"><i class="bi bi-grid"></i> الخدمات</a>
            <a class="nav-link" href="order-service.php"><i class="bi bi-plus-square"></i> طلب جديد</a>
            <a class="nav-link" href="AddBalance.php"><i class="bi bi-wallet2"></i> إضافة رصيد</a>
            <a class="nav-link" href="payment-methods.php"><i class="bi bi-credit-card"></i> طرق الدفع</a>
            <a class="nav-link" href="contact.php"><i class="bi bi-telephone"></i> اتصل بنا</a>
            <?php if (isLoggedIn()): ?>
                <a class="nav-link" href="dashboard.php"><i class="bi bi-person-circle"></i> لوحة التحكم</a>
                <a class="nav-link btn mt-2" href="logout.php"><i class="bi bi-box-arrow-right"></i> تسجيل الخروج</a>
            <?php else: ?>
                <a class="nav-link" href="login.php"><i class="bi bi-box-arrow-in-right"></i> تسجيل الدخول</a>
                <a class="nav-link btn mt-2" href="register.php"><i class="bi bi-person-plus"></i> إنشاء حساب</a>
            <?php endif; ?>
        </nav>
    </aside>
    <div class="container mt-4"> 
    <script>
    // فتح/إغلاق القائمة المنسدلة مع تأثير سلس
    const hamburger = document.getElementById('hamburgerMenu');
    const dropdown = document.getElementById('mobileDropdown');
    hamburger.addEventListener('click', function(e) {
        e.stopPropagation();
        dropdown.classList.toggle('show');
    });
    // إغلاق القائمة عند الضغط خارجها أو على أي رابط
    document.addEventListener('click', function(e) {
        if (window.innerWidth <= 991) {
            dropdown.classList.remove('show');
        }
    });
    dropdown.querySelectorAll('.dropdown-link').forEach(link => {
        link.addEventListener('click', function() {
            if (window.innerWidth <= 991) {
                dropdown.classList.remove('show');
            }
        });
    });
    window.addEventListener('resize', function() {
        if (window.innerWidth > 991) {
            dropdown.classList.remove('show');
        }
    });
    </script> 

<?php
// Get user info if logged in
$user_info = null;
if (isset($_SESSION['user_id'])) {
    $query = "SELECT * FROM users WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $_SESSION['user_id']);
    $stmt->execute();
    $result = $stmt->get_result();
    $user_info = $result->fetch_assoc();
}

// Get user's order count
$order_count = 0;
if ($user_info) {
    $query = "SELECT COUNT(*) as count FROM orders WHERE user_id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $_SESSION['user_id']);
    $stmt->execute();
    $result = $stmt->get_result();
    $order_count = $result->fetch_assoc()['count'];
}
?>
<?php if ($user_info): ?>
<div style="background:linear-gradient(90deg,#23263a 60%,#7367f0 100%);color:#fff;padding:10px 0 7px 0;font-size:1.08rem;text-align:center;letter-spacing:1px;z-index:2001;position:relative;">
    <span style="margin:0 18px;">👤 <b><?= htmlspecialchars($user_info['username']) ?></b></span>
    <span style="margin:0 18px;">💰 الرصيد: <b><?= number_format($user_info['balance'],2) ?></b> $</span>
    <span style="margin:0 18px;">📝 عدد الطلبات: <b><?= $order_count ?></b></span>
</div>
<?php endif; ?> 
<script>
if(window.innerWidth > 600) {
  // دائرة المؤشر
  const outer = document.createElement('div');
  outer.className = 'mouse-follow-outer';
  const inner = document.createElement('div');
  inner.className = 'mouse-follow-inner';
  document.body.appendChild(outer);
  document.body.appendChild(inner);

  // الذيل
  const trailLength = 10;
  const trail = [];
  for(let i=0; i<trailLength; i++) {
    const dot = document.createElement('div');
    dot.className = 'mouse-trail-dot';
    dot.style.opacity = (0.13 - i*0.012) + '';
    dot.style.width = dot.style.height = (16 - i*0.7) + 'px';
    document.body.appendChild(dot);
    trail.push(dot);
  }
  let mouseX = window.innerWidth/2, mouseY = window.innerHeight/2;
  document.addEventListener('mousemove', function(e) {
    mouseX = e.clientX;
    mouseY = e.clientY;
    outer.style.left = (mouseX - 22) + 'px';
    outer.style.top = (mouseY - 22) + 'px';
    inner.style.left = (mouseX - 8) + 'px';
    inner.style.top = (mouseY - 8) + 'px';
  });
  function animateTrail() {
    let x = mouseX, y = mouseY;
    for(let i=0; i<trail.length; i++) {
      const dot = trail[i];
      dot.style.left = (x - dot.offsetWidth/2) + 'px';
      dot.style.top = (y - dot.offsetHeight/2) + 'px';
      x += (trail[i+1]?.offsetLeft - x || 0) * 0.35;
      y += (trail[i+1]?.offsetTop - y || 0) * 0.35;
    }
    requestAnimationFrame(animateTrail);
  }
  animateTrail();
}
</script> 
</body>
</html> 